; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc < %s -mtriple aarch64 -mattr=+sve -aarch64-enable-gisel-sve=1  | FileCheck %s  --check-prefixes=CHECK,CHECK-SDAG
; RUN: llc < %s -mtriple aarch64 -mattr=+sve -global-isel -aarch64-enable-gisel-sve=1 | FileCheck %s --check-prefixes=CHECK,CHECK-GS

; REQUIRES: asserts

;; add
define <vscale x 2 x i64> @addnxv2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b) {
; CHECK-SDAG-LABEL: addnxv2i64:
; CHECK-SDAG:       // %bb.0: // %entry
; CHECK-SDAG-NEXT:    add z0.d, z0.d, #9 // =0x9
; CHECK-SDAG-NEXT:    ret
;
; CHECK-GS-LABEL: addnxv2i64:
; CHECK-GS:       // %bb.0: // %entry
; CHECK-GS-NEXT:    mov w8, #9 // =0x9
; CHECK-GS-NEXT:    mov z1.d, x8
; CHECK-GS-NEXT:    add z0.d, z0.d, z1.d
; CHECK-GS-NEXT:    ret
entry:
  %c = add <vscale x 2 x i64> %a, splat (i64 9)
  ret <vscale x 2 x i64> %c
}

define <vscale x 2 x i64> @splarnxv2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b) {
; CHECK-SDAG-LABEL: splarnxv2i64:
; CHECK-SDAG:       // %bb.0: // %entry
; CHECK-SDAG-NEXT:    mov z0.d, #9 // =0x9
; CHECK-SDAG-NEXT:    ret
;
; CHECK-GS-LABEL: splarnxv2i64:
; CHECK-GS:       // %bb.0: // %entry
; CHECK-GS-NEXT:    mov w8, #9 // =0x9
; CHECK-GS-NEXT:    mov z0.d, x8
; CHECK-GS-NEXT:    ret
entry:
  ret <vscale x 2 x i64> splat (i64 9)
}

define <vscale x 4 x i32> @addnxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b) {
; CHECK-SDAG-LABEL: addnxv4i32:
; CHECK-SDAG:       // %bb.0: // %entry
; CHECK-SDAG-NEXT:    add z0.s, z0.s, #9 // =0x9
; CHECK-SDAG-NEXT:    ret
;
; CHECK-GS-LABEL: addnxv4i32:
; CHECK-GS:       // %bb.0: // %entry
; CHECK-GS-NEXT:    mov w8, #9 // =0x9
; CHECK-GS-NEXT:    mov z1.s, w8
; CHECK-GS-NEXT:    add z0.s, z0.s, z1.s
; CHECK-GS-NEXT:    ret
entry:
  %c = add <vscale x 4 x i32> %a, splat (i32 9)
  ret <vscale x 4 x i32> %c
}

define <vscale x 4 x i32> @splatnxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b) {
; CHECK-SDAG-LABEL: splatnxv4i32:
; CHECK-SDAG:       // %bb.0: // %entry
; CHECK-SDAG-NEXT:    mov z0.s, #9 // =0x9
; CHECK-SDAG-NEXT:    ret
;
; CHECK-GS-LABEL: splatnxv4i32:
; CHECK-GS:       // %bb.0: // %entry
; CHECK-GS-NEXT:    mov w8, #9 // =0x9
; CHECK-GS-NEXT:    mov z0.s, w8
; CHECK-GS-NEXT:    ret
entry:
  ret <vscale x 4 x i32> splat (i32 9)
}

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
