; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5

; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 < %s | FileCheck %s

define i64 @narrow_add(i64 %a, i64 %b) {
; CHECK-LABEL: narrow_add:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_and_b32_e32 v0, 0x7fffffff, v0
; CHECK-NEXT:    v_and_b32_e32 v1, 0x7fffffff, v2
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; CHECK-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_add_nc_u32 v0, v0, v1
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %zext0 = and i64 %a, 2147483647
  %zext1 = and i64 %b, 2147483647
  %add = add i64 %zext0, %zext1
  ret i64 %add
}

define i64 @narrow_add_1(i64 %a, i64 %b) {
; CHECK-LABEL: narrow_add_1:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_bfi_b32 v0, 0x7fffffff, v0, v2
; CHECK-NEXT:    v_mov_b32_e32 v1, 0
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %zext0 = and i64 %a, 2147483647
  %zext1 = and i64 %b, 2147483648
  %add = add i64 %zext0, %zext1
  ret i64 %add
}

define <2 x i64> @narrow_add_vec(<2 x i64> %a, <2 x i64> %b) #0 {
; CHECK-LABEL: narrow_add_vec:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_and_b32_e32 v1, 30, v2
; CHECK-NEXT:    v_and_b32_e32 v0, 0x7fffffff, v0
; CHECK-NEXT:    v_and_b32_e32 v2, 0x7fffffff, v4
; CHECK-NEXT:    v_and_b32_e32 v3, 0x7ffffffe, v6
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; CHECK-NEXT:    v_add_nc_u32_e32 v0, v0, v2
; CHECK-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_add_nc_u32 v2, v1, v3
; CHECK-NEXT:    v_mov_b32_e32 v3, 0
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %zext0 = and <2 x i64> %a, <i64 2147483647, i64 30>
  %zext1 = and <2 x i64> %b, <i64 2147483647, i64 2147483646>
  %add = add <2 x i64> %zext0, %zext1
  ret <2 x i64> %add
}

define <2 x i32> @narrow_add_vec_1(<2 x i32> %a, <2 x i32> %b) #0 {
; CHECK-LABEL: narrow_add_vec_1:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_and_b32_e32 v1, 0x3fff, v1
; CHECK-NEXT:    v_and_b32_e32 v0, 0x4000, v0
; CHECK-NEXT:    v_and_b32_e32 v2, 0x4000, v2
; CHECK-NEXT:    v_and_b32_e32 v3, 0x4001, v3
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; CHECK-NEXT:    v_add_nc_u32_e32 v0, v0, v2
; CHECK-NEXT:    v_add_nc_u32_e32 v1, v1, v3
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %zext0 = and <2 x i32> %a, <i32 16384, i32 16383>
  %zext1 = and <2 x i32> %b, <i32 16384, i32 16385>
  %add = add <2 x i32> %zext0, %zext1
  ret <2 x i32> %add
}

define i64 @narrow_mul(i64 %a, i64 %b) {
; CHECK-LABEL: narrow_mul:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_and_b32_e32 v1, 2, v2
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; CHECK-NEXT:    v_mul_lo_u32 v0, v0, v1
; CHECK-NEXT:    v_mov_b32_e32 v1, 0
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %zext0 = and i64 %a, 2147483647
  %zext1 = and i64 %b, 2
  %mul = mul i64 %zext0, %zext1
  ret i64 %mul
}

define i64 @narrow_mul_1(i64 %a, i64 %b) {
; CHECK-LABEL: narrow_mul_1:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_and_b32_e32 v1, 0xf73594, v0
; CHECK-NEXT:    v_and_b32_e32 v2, 0x100, v2
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; CHECK-NEXT:    v_mul_u32_u24_e32 v0, v1, v2
; CHECK-NEXT:    v_mul_hi_u32_u24_e32 v1, v1, v2
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %zext0 = and i64 %a, 16201108
  %zext1 = and i64 %b, 256
  %mul = mul i64 %zext0, %zext1
  ret i64 %mul
}

define <2 x i64> @narrow_mul_vec(<2 x i64> %a, <2 x i64> %b) #0 {
; CHECK-LABEL: narrow_mul_vec:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_and_b32_e32 v0, 0x2d48aff, v0
; CHECK-NEXT:    v_and_b32_e32 v1, 0x50, v4
; CHECK-NEXT:    v_and_b32_e32 v2, 50, v2
; CHECK-NEXT:    v_and_b32_e32 v3, 20, v6
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; CHECK-NEXT:    v_mul_lo_u32 v0, v0, v1
; CHECK-NEXT:    v_mov_b32_e32 v1, 0
; CHECK-NEXT:    v_mul_u32_u24_e32 v2, v2, v3
; CHECK-NEXT:    v_mov_b32_e32 v3, 0
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %zext0 = and <2 x i64> %a, <i64 47483647, i64 50>
  %zext1 = and <2 x i64> %b, <i64 80, i64 20>
  %mul = mul <2 x i64> %zext0, %zext1
  ret <2 x i64> %mul
}

define <2 x i32> @narrow_add_mul_1(<2 x i32> %a, <2 x i32> %b) #0 {
; CHECK-LABEL: narrow_add_mul_1:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_and_b32_e32 v1, 0x4000, v1
; CHECK-NEXT:    v_and_b32_e32 v0, 0x4000, v0
; CHECK-NEXT:    v_and_b32_e32 v2, 3, v2
; CHECK-NEXT:    v_and_b32_e32 v3, 2, v3
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; CHECK-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; CHECK-NEXT:    v_mul_u32_u24_e32 v1, v1, v3
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %zext0 = and <2 x i32> %a, <i32 16384, i32 16384>
  %zext1 = and <2 x i32> %b, <i32 3, i32 2>
  %mul = mul <2 x i32> %zext0, %zext1
  ret <2 x i32> %mul
}

define i64 @no_narrow_add(i64 %a, i64 %b) {
; CHECK-LABEL: no_narrow_add:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_and_b32_e32 v0, 0x80000000, v0
; CHECK-NEXT:    v_and_b32_e32 v1, 0x80000000, v2
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; CHECK-NEXT:    v_add_co_u32 v0, s0, v0, v1
; CHECK-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, 0, s0
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %zext0 = and i64 %a, 2147483648
  %zext1 = and i64 %b, 2147483648
  %add = add i64 %zext0, %zext1
  ret i64 %add
}

define i64 @no_narrow_add_1(i64 %a, i64 %b) {
; CHECK-LABEL: no_narrow_add_1:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_and_b32_e32 v1, 1, v2
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; CHECK-NEXT:    v_add_co_u32 v0, s0, v0, v1
; CHECK-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, 0, s0
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %zext0 = and i64 %a, 4294967295
  %zext1 = and i64 %b, 1
  %add = add i64 %zext0, %zext1
  ret i64 %add
}

define <2 x i64> @no_narrow_add_vec(<2 x i64> %a, <2 x i64> %b) #0 {
; CHECK-LABEL: no_narrow_add_vec:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_and_b32_e32 v0, 0x80000000, v0
; CHECK-NEXT:    v_and_b32_e32 v1, 0x80000000, v4
; CHECK-NEXT:    v_and_b32_e32 v2, 30, v2
; CHECK-NEXT:    v_and_b32_e32 v3, 0x7ffffffe, v6
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; CHECK-NEXT:    v_add_co_u32 v0, s0, v0, v1
; CHECK-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, 0, s0
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; CHECK-NEXT:    v_add_co_u32 v2, s0, v2, v3
; CHECK-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, 0, s0
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %zext0 = and <2 x i64> %a, <i64 2147483648, i64 30>
  %zext1 = and <2 x i64> %b, <i64 2147483648, i64 2147483646>
  %add = add <2 x i64> %zext0, %zext1
  ret <2 x i64> %add
}

define i64 @no_narrow_mul(i64 %a, i64 %b) {
; CHECK-LABEL: no_narrow_mul:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_and_b32_e32 v0, 0x80000000, v0
; CHECK-NEXT:    v_and_b32_e32 v1, 2, v2
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; CHECK-NEXT:    v_mul_hi_u32 v1, v0, v1
; CHECK-NEXT:    v_mov_b32_e32 v0, 0
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %zext0 = and i64 %a, 2147483648
  %zext1 = and i64 %b, 2
  %mul = mul i64 %zext0, %zext1
  ret i64 %mul
}

define <2 x i64> @no_narrow_mul_vec(<2 x i64> %a, <2 x i64> %b) #0 {
; CHECK-LABEL: no_narrow_mul_vec:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_and_b32_e32 v1, 0x8000, v0
; CHECK-NEXT:    v_and_b32_e32 v3, 0x20000, v4
; CHECK-NEXT:    v_and_b32_e32 v4, 50, v2
; CHECK-NEXT:    v_and_b32_e32 v5, 20, v6
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; CHECK-NEXT:    v_mul_u32_u24_e32 v0, v1, v3
; CHECK-NEXT:    v_mul_hi_u32_u24_e32 v1, v1, v3
; CHECK-NEXT:    v_mul_u32_u24_e32 v2, v4, v5
; CHECK-NEXT:    v_mul_hi_u32_u24_e32 v3, v4, v5
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %zext0 = and <2 x i64> %a, <i64 32768, i64 50>
  %zext1 = and <2 x i64> %b, <i64 131072, i64 20>
  %mul = mul <2 x i64> %zext0, %zext1
  ret <2 x i64> %mul
}
