; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-apple-darwin9 -mattr=-sse3,+sse2 | FileCheck %s --check-prefix=SSE2
; RUN: llc < %s -mtriple=i686-apple-darwin9 -mattr=-sse4.2,+sse4.1 | FileCheck %s --check-prefix=SSE41
; RUN: llc < %s -mtriple=i686-apple-darwin9 -mattr=+sse4.2 | FileCheck %s --check-prefix=SSE42

define <2 x i64> @test1(<2 x i64> %A, <2 x i64> %B) nounwind {
; SSE2-LABEL: test1:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,0,2147483648,0]
; SSE2-NEXT:    pxor %xmm2, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,3,3]
; SSE2-NEXT:    pand %xmm3, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,3,3]
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    retl
;
; SSE41-LABEL: test1:
; SSE41:       ## %bb.0:
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm2, %xmm1
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,3,3]
; SSE41-NEXT:    pand %xmm3, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,3,3]
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    retl
;
; SSE42-LABEL: test1:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pcmpgtq %xmm1, %xmm0
; SSE42-NEXT:    retl
  %C = icmp sgt <2 x i64> %A, %B
  %D = sext <2 x i1> %C to <2 x i64>
  ret <2 x i64> %D
}

define <2 x i64> @test2(<2 x i64> %A, <2 x i64> %B) nounwind {
; SSE2-LABEL: test2:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    retl
;
; SSE41-LABEL: test2:
; SSE41:       ## %bb.0:
; SSE41-NEXT:    pcmpeqq %xmm1, %xmm0
; SSE41-NEXT:    retl
;
; SSE42-LABEL: test2:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pcmpeqq %xmm1, %xmm0
; SSE42-NEXT:    retl
  %C = icmp eq <2 x i64> %A, %B
  %D = sext <2 x i1> %C to <2 x i64>
  ret <2 x i64> %D
}
